-- Migration: Update role ENUM from 'programming' to 'imtc'
-- Date: 2024-01-XX
-- Description: Modifies the admin_users table to change the role ENUM values

-- Step 1: Modify the ENUM to include 'imtc' and remove 'programming'
ALTER TABLE admin_users 
MODIFY COLUMN role ENUM('bursary', 'imtc') NOT NULL;

-- Step 2: Update existing 'programming' records to 'imtc'
UPDATE admin_users 
SET role = 'imtc' 
WHERE role = 'programming';

-- Step 3: Verify the changes
SELECT role, COUNT(*) as count 
FROM admin_users 
GROUP BY role;

-- Step 4: Show the updated table structure
DESCRIBE admin_users;
